<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * Employee
 *
 * @ORM\Table(name="employees")
 * @ORM\Entity
 *
 * @ExclusionPolicy("all")
 */
class Employee
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"employeesDetails","companyDetails"})
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=50)
     *
     * @Expose
     * @AnnotationGroups({"employeesDetails","companyDetails"})
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="surname", type="string", length=50)
     *
     * @Expose
     * @AnnotationGroups({"employeesDetails","companyDetails"})
     */
    private $surname;

    /**
     * @var string
     *
     * @ORM\Column(name="education", type="string", length=50)
     *
     * @Expose
     * @AnnotationGroups({"employeesDetails","companyDetails"})
     */
    private $education;

    /**
     * @var string
     *
     * @ORM\Column(name="studies", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"employeesDetails","companyDetails"})
     */
    private $studies;

    /**
     * @var string
     *
     * @ORM\Column(name="driver", type="string", length=50)
     *
     * @Expose
     * @AnnotationGroups({"employeesDetails","companyDetails"})
     */
    private $driver;

    /**
     * @var integer
     *
     * @ORM\Column(name="age", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"employeesDetails","companyDetails"})
     */
    private $age;

    /**
     * @var integer
     *
     * @ORM\Column(name="seniority", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"employeesDetails","companyDetails"})
     */
    private $seniority;

    /**
     * @var string $isWorker
     *
     * @ORM\Column(name="is_worker", type="boolean")
     *
     * @Expose
     * @AnnotationGroups({"employeesDetails","companyDetails"})
     */
    private $isWorker;

    /**
     * @var integer
     *
     * @ORM\Column(name="salary", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"employeesDetails","companyDetails"})
     */
    private $salary;

    /**
     * @ORM\OneToMany(targetEntity="CompanyEmployee", mappedBy="employee")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails"})
     */
    protected $companyEmployees;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Employee
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set surname
     *
     * @param string $surname
     * @return Employee
     */
    public function setSurname($surname)
    {
        $this->surname = $surname;
    
        return $this;
    }

    /**
     * Get surname
     *
     * @return string 
     */
    public function getSurname()
    {
        return $this->surname;
    }

    /**
     * Set education
     *
     * @param string $education
     * @return Employee
     */
    public function setEducation($education)
    {
        $this->education = $education;
    
        return $this;
    }

    /**
     * Get education
     *
     * @return string 
     */
    public function getEducation()
    {
        return $this->education;
    }

    /**
     * Set seniority
     *
     * @param integer $seniority
     * @return Employee
     */
    public function setSeniority($seniority)
    {
        $this->seniority = $seniority;
    
        return $this;
    }

    /**
     * Get seniority
     *
     * @return integer 
     */
    public function getSeniority()
    {
        return $this->seniority;
    }

    /**
     * Set salary
     *
     * @param integer $salary
     * @return Employee
     */
    public function setSalary($salary)
    {
        $this->salary = $salary;
    
        return $this;
    }

    /**
     * Get salary
     *
     * @return integer
     */
    public function getSalary()
    {
        return $this->salary;
    }

    /**
     * Set company_id
     *
     * @param integer $companyId
     * @return Employee
     */
    public function setCompanyId($companyId)
    {
        $this->company_id = $companyId;
    
        return $this;
    }

    /**
     * Get company_id
     *
     * @return integer 
     */
    public function getCompanyId()
    {
        return $this->company_id;
    }

    /**
     * Set company
     *
     * @param \VM\ApiBundle\Entity\Company $company
     * @return Employee
     */
    public function setCompany(\VM\ApiBundle\Entity\Company $company = null)
    {
        $this->company = $company;
    
        return $this;
    }

    /**
     * Get company
     *
     * @return \VM\ApiBundle\Entity\Company 
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->companyEmployees = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Add companyEmployees
     *
     * @param \VM\ApiBundle\Entity\CompanyEmployee $companyEmployees
     * @return Employee
     */
    public function addCompanyEmployee(\VM\ApiBundle\Entity\CompanyEmployee $companyEmployees)
    {
        $this->companyEmployees[] = $companyEmployees;
    
        return $this;
    }

    /**
     * Remove companyEmployees
     *
     * @param \VM\ApiBundle\Entity\CompanyEmployee $companyEmployees
     */
    public function removeCompanyEmployee(\VM\ApiBundle\Entity\CompanyEmployee $companyEmployees)
    {
        $this->companyEmployees->removeElement($companyEmployees);
    }

    /**
     * Get companyEmployees
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCompanyEmployees()
    {
        return $this->companyEmployees;
    }

    /**
     * Set isWorker
     *
     * @param boolean $isWorker
     * @return Employee
     */
    public function setIsWorker($isWorker)
    {
        $this->isWorker = $isWorker;
    
        return $this;
    }

    /**
     * Get isWorker
     *
     * @return boolean 
     */
    public function getIsWorker()
    {
        return $this->isWorker;
    }

    /**
     * Set studies
     *
     * @param string $studies
     * @return Employee
     */
    public function setStudies($studies)
    {
        $this->studies = $studies;
    
        return $this;
    }

    /**
     * Get studies
     *
     * @return string 
     */
    public function getStudies()
    {
        return $this->studies;
    }

    /**
     * Set driver
     *
     * @param string $driver
     * @return Employee
     */
    public function setDriver($driver)
    {
        $this->driver = $driver;
    
        return $this;
    }

    /**
     * Get driver
     *
     * @return string 
     */
    public function getDriver()
    {
        return $this->driver;
    }

    /**
     * Set age
     *
     * @param integer $age
     * @return Employee
     */
    public function setAge($age)
    {
        $this->age = $age;
    
        return $this;
    }

    /**
     * Get age
     *
     * @return integer 
     */
    public function getAge()
    {
        return $this->age;
    }
}